%% Function to transform a set of  3D coordinates
% where transx is the transformed set of entered coordinates x using 3
% rotations in a vector called trans.
%
% Ali MacLeod
% University of Bath 2015
%
% transx are the transformed coordinates of x given 3 rotations
%
function transx = TransFunRotOnly(x,trans)
%% Basic Rotation about x,y and z
%
thetax=trans(1);
thetay=trans(2);
thetaz=trans(3);
%
M=[ cos(thetay) * cos(thetaz) , ( cos(thetax) * sin(thetaz) ) + ( sin(thetax) * sin(thetay) * cos(thetaz) ) , ( sin(thetax) * sin(thetaz) ) - ( cos(thetax) * sin(thetay) * cos(thetaz)) ;
   -cos(thetay) * sin(thetaz) , ( cos(thetax) * cos(thetaz) ) - ( sin(thetax) * sin(thetay) * sin(thetaz) ) , ( sin(thetax) * cos(thetaz) ) + ( cos(thetax) * sin(thetay) * sin(thetaz)) ;
    sin(thetay) , -sin(thetax) * cos(thetay) , cos(thetax) * cos(thetay) ];
%
%%
transxvec=M*x';
%
transx=transxvec';
%
end


